<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rb_kvalif_410";

// Establish connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die(json_encode(["error" => "Database connection failed: " . $conn->connect_error]));
}

header('Content-Type: application/json');

// Get the action
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'create':
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['question'], $data['answer'])) {
            echo json_encode(["error" => "Invalid input data."]);
            exit;
        }

        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        $stmt = $conn->prepare("INSERT INTO rb_kvalif_faq_410 (question, answer) VALUES (?, ?)");
        $stmt->bind_param("ss", $question, $answer);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    case 'read':
        $result = $conn->query("SELECT * FROM rb_kvalif_faq_410");

        if (!$result) {
            echo json_encode(["error" => $conn->error]);
            exit;
        }

        $faqs = $result->fetch_all(MYSQLI_ASSOC);
        echo json_encode($faqs);
        break;

    case 'update':
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['id'], $data['question'], $data['answer'])) {
            echo json_encode(["error" => "Invalid input data."]);
            exit;
        }

        $id = intval($data['id']);
        $question = $conn->real_escape_string($data['question']);
        $answer = $conn->real_escape_string($data['answer']);

        $stmt = $conn->prepare("UPDATE rb_kvalif_faq_410 SET question = ?, answer = ? WHERE id = ?");
        $stmt->bind_param("ssi", $question, $answer, $id);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    case 'delete':
        $id = intval($_GET['id']);
        if (!$id) {
            echo json_encode(["error" => "Invalid ID."]);
            exit;
        }

        $stmt = $conn->prepare("DELETE FROM rb_kvalif_faq_410 WHERE id = ?");
        $stmt->bind_param("i", $id);

        if (!$stmt->execute()) {
            echo json_encode(["error" => $stmt->error]);
            exit;
        }

        echo json_encode(["success" => true]);
        break;

    default:
        echo json_encode(["error" => "Invalid action."]);
}

$conn->close();
?>
